% Chudik, Pesaran and Yang (2018)
% 
% We use the proposed half-panel jackknife estimator to estimate equation
% (27) of the paper. The estimates are reported in Table 4, column (3.b).
% 
% This empirical application is based on Berger, Easterly, Nunn and 
% Satyanath (2013, American Economic Review) "Commercial imperialism?
% political influence and trade during the cold war".

clc
clear
close all

load CPY_ExportUS_data

NT = size(X, 1);

Group = X(:, 1);
Time = X(:, 2);

N = max(Group);
T = max(Time);

Xa = X;
Xa((Xa(:, 15) == 0), :) = [];
Xb = X;
Xb((Xb(:, 16) == 0), :) = [];

NTa = size(Xa, 1);
NTb = size(Xb, 1);

Groupa = Xa(:, 1);
Timea = Xa(:, 2) - min(Xa(:, 2)) + 1;
Groupb = Xb(:, 1);
Timeb = Xb(:, 2) - min(Xb(:, 2)) + 1;

Ta = max(Timea);
Tb = max(Timeb);

sample = zeros(N, T);
samplea = zeros(N, Ta);
sampleb = zeros(N, Tb);

for j = 1:NT
    
    i = Group(j);
    t = Time(j);
    sample(i, t) = 1;
    
end

for j = 1:NTa
    
    i = Groupa(j);
    t = Timea(j);
    samplea(i, t) = 1;
    
end

for j = 1:NTb
    
    i = Groupb(j);
    t = Timeb(j);
    sampleb(i, t) = 1;
    
end

clear j i t

longY = X(:, 3);
longX1 = X(:, 4);
longX2 = X(:, 5);
longX3 = X(:, 6);
longX4 = X(:, 7);
longX5 = X(:, 8);
longX6 = X(:, 9);
longX7 = X(:, 10);
longX8 = X(:, 11);
longX9 = X(:, 12);
longX10 = X(:, 13);
longX11 = X(:, 14);

longYa = Xa(:, 3);
longX1a = Xa(:, 4);
longX2a = Xa(:, 5);
longX3a = Xa(:, 6);
longX4a = Xa(:, 7);
longX5a = Xa(:, 8);
longX6a = Xa(:, 9);
longX7a = Xa(:, 10);
longX8a = Xa(:, 11);
longX9a = Xa(:, 12);
longX10a = Xa(:, 13);
longX11a = Xa(:, 14);

longYb = Xb(:, 3);
longX1b = Xb(:, 4);
longX2b = Xb(:, 5);
longX3b = Xb(:, 6);
longX4b = Xb(:, 7);
longX5b = Xb(:, 8);
longX6b = Xb(:, 9);
longX7b = Xb(:, 10);
longX8b = Xb(:, 11);
longX9b = Xb(:, 12);
longX10b = Xb(:, 13);
longX11b = Xb(:, 14);

Ti = sum(sample, 2);
Nt = sum(sample, 1);

Tia = sum(samplea, 2);
Tib = sum(sampleb, 2);
Nta = sum(samplea, 1);
Ntb = sum(sampleb, 1);

Z1 = ones(Ti(1), 1);
Z2 = eye(T) .* (ones(T, 1) * sample(1, :));
Z2(all(~Z2, 2), :) = [];

Z1a = ones(Tia(1), 1);
Z1b = ones(Tib(1), 1);
Z2a = eye(Ta) .* (ones(Ta, 1) * samplea(1, :));
Z2a(all(~Z2a, 2), :) = [];
Z2b = eye(Tb) .* (ones(Tb, 1) * sampleb(1, :));
Z2b(all(~Z2b, 2), :) = [];

for i = 2:N
    
    Z1 = blkdiag(Z1, ones(Ti(i), 1));
    
    z2 = eye(T) .* (ones(T, 1) * sample(i, :));
    z2(all(~z2, 2), :) = [];
    Z2 = [Z2; z2];
    
    Z1a = blkdiag(Z1a, ones(Tia(i), 1));
    Z1b = blkdiag(Z1b, ones(Tib(i), 1));
    
    z2a = eye(Ta) .* (ones(Ta, 1) * samplea(i, :));
    z2a(all(~z2a, 2), :) = [];
    Z2a = [Z2a; z2a];
    z2b = eye(Tb) .* (ones(Tb, 1) * sampleb(i, :));
    z2b(all(~z2b, 2), :) = [];
    Z2b = [Z2b; z2b];
    
    clear z2 z2a z2b
    
end

y = longY;
x = [longX1, longX2, longX3, longX4, longX5, longX6, longX7, longX8, longX9, longX10, longX11];

ya = longYa;
xa = [longX1a, longX2a, longX3a, longX4a, longX5a, longX6a, longX7a, longX8a, longX9a, longX10a, longX11a];

yb = longYb;
xb = [longX1b, longX2b, longX3b, longX4b, longX5b, longX6b, longX7b, longX8b, longX9b, longX10b, longX11b];

Z = [Z1, Z2];
M = eye(NT) - Z * pinv(Z' * Z) * Z';

My = M * y;
Mx = M * x;

beta = (Mx' * Mx)^(-1) * Mx' * My

Mu = My - Mx * beta;
K = size(Mx, 2);
MxMu = Mx;

for k = 1:K
    
    MxMu(:, k) = Mx(:, k) .* Mu;
    
end

var = (Mx' * Mx)^(-1) * MxMu' * MxMu * (Mx' * Mx)^(-1);
std = sqrt(diag(var))

Za = [Z1a, Z2a];
Ma = eye(NTa) - Za * pinv(Za' * Za) * Za';
Zb = [Z1b, Z2b];
Mb = eye(NTb) - Zb * pinv(Zb' * Zb) * Zb';

Maya = Ma * ya;
Maxa = Ma * xa;
Mbyb = Mb * yb;
Mbxb = Mb * xb;

betaa = (Maxa' * Maxa)^(-1) * Maxa' * Maya;
betab = (Mbxb' * Mbxb)^(-1) * Mbxb' * Mbyb;

betaJ = beta * 2 - betaa * 0.5 - betab * 0.5

Mabxab = [Maxa(1:Tia(1), :); Mbxb(1:Tib(1), :)];

begina = Tia(1) + 1;
beginb = Tib(1) + 1;

for i = 2:N
    
    enda = begina + Tia(i) - 1;
    endb = beginb + Tib(i) - 1;
    
    Mabxab = [Mabxab; Maxa(begina:enda, :); Mbxb(beginb:endb, :)];
    
    begina = enda + 1;
    beginb = endb + 1;
    
end

MuJ = My - Mx * betaJ;
d = 2 * Mx - Mabxab;

dMuJ = d;

for k = 1:K
    
    dMuJ(:, k) = d(:, k) .* MuJ;
    
end

varJ = (Mx' * Mx)^(-1) * dMuJ' * dMuJ * (Mx' * Mx)^(-1);
stdJ = sqrt(diag(varJ))

Sigs = beta ./ std
SigsJ = betaJ ./ stdJ

short = [beta, std, Sigs]
shortJ = [betaJ, stdJ, SigsJ]